/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.msg;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class MimeUtility {
    static URLCodec codec = null;

    public static String getURLEncodedString(String str) throws UnsupportedEncodingException {
        return codec.getURLEncodedString(str);
    }

    public static String getURLEncodedString(String str, String charset) throws UnsupportedEncodingException {
        return codec.getURLEncodedString(str, charset);
    }

    public static String getURLDecodedString(String str) throws UnsupportedEncodingException {
        return codec.getURLDecodedString(str);
    }

    public static String getURLDecodedString(String str, String charset) throws UnsupportedEncodingException {
        return codec.getURLDecodedString(str, charset);
    }

    static {
        String vmspec = System.getProperty("java.specification.version");
        float version = 1.3f;
        try {
            version = Float.parseFloat(vmspec);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        codec = version >= 1.4f ? new Wrapper() : new ManualImpl();
    }

    static class ManualImpl
    implements URLCodec {
        ManualImpl() {
        }

        public String getURLEncodedString(String str) throws UnsupportedEncodingException {
            return this.getURLEncodedString(str, System.getProperty("file.encoding"));
        }

        public String getURLEncodedString(String str, String encoding) throws UnsupportedEncodingException {
            StringBuffer sb = new StringBuffer();
            byte[] b = str.getBytes(encoding);
            for (int i = 0; i < b.length; ++i) {
                sb.append("%");
                int value = b[i] < 0 ? b[i] + 256 : b[i];
                String hexa = Integer.toHexString(value);
                if (hexa.length() == 1) {
                    sb.append("0");
                }
                sb.append(hexa.toUpperCase());
            }
            return sb.toString();
        }

        public String getURLDecodedString(String str) throws UnsupportedEncodingException {
            return this.getURLDecodedString(str, System.getProperty("file.encoding"));
        }

        public String getURLDecodedString(String str, String encoding) throws UnsupportedEncodingException {
            StringBuffer sb = new StringBuffer();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
            boolean isURLEncode = false;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) == '%') {
                    int v = -1;
                    try {
                        v = Integer.valueOf(str.substring(i + 1, i + 3), 16);
                        bos.write(v);
                        isURLEncode = true;
                        i += 2;
                    }
                    catch (NumberFormatException e) {
                        sb.append(str.charAt(i));
                    }
                    continue;
                }
                if (isURLEncode) {
                    isURLEncode = false;
                    sb.append(new String(bos.toByteArray(), encoding));
                    bos.reset();
                }
                sb.append(str.charAt(i));
            }
            if (isURLEncode) {
                sb.append(new String(bos.toByteArray(), encoding));
            }
            return sb.toString();
        }
    }

    static interface URLCodec {
        public String getURLEncodedString(String var1) throws UnsupportedEncodingException;

        public String getURLEncodedString(String var1, String var2) throws UnsupportedEncodingException;

        public String getURLDecodedString(String var1) throws UnsupportedEncodingException;

        public String getURLDecodedString(String var1, String var2) throws UnsupportedEncodingException;
    }

    static class Wrapper
    implements URLCodec {
        Wrapper() {
        }

        public String getURLEncodedString(String str) throws UnsupportedEncodingException {
            return this.getURLEncodedString(str, System.getProperty("file.encoding"));
        }

        public String getURLEncodedString(String str, String charset) throws UnsupportedEncodingException {
            return URLEncoder.encode(str, charset);
        }

        public String getURLDecodedString(String str) throws UnsupportedEncodingException {
            return this.getURLDecodedString(str, System.getProperty("file.encoding"));
        }

        public String getURLDecodedString(String str, String charset) throws UnsupportedEncodingException {
            return URLDecoder.decode(str, charset);
        }
    }
}

